/*##################################################################
Crer la camra
 
FNCT_CamMakeCamera()
	@param1 Position de dpart de la camera
	@return la camera cre
 
Ex : _cam = [ (getPos player) ] call FNCT_CamMakeCamera;
##################################################################*/
 
FNCT_CamMakeCamera ={
 
	_pos = _this select 0;
 
	enableRadio true;
	showCinemaBorder true;
 
	_cam = "camera" camCreate _pos;
	_cam cameraEffect ["internal", "back"];
	_cam camSetFov 1.0;
	_cam;
};
 
 
 
/*##################################################################
Librer la camra
 
FNCT_CamFreeCamera()
	@param1 la camera a dtruire
	@return la camera
 
Ex : _cam = [ _cam ] call FNCT_CamMakeCamera;
##################################################################*/
 
FNCT_CamFreeCamera = {
 
	_cam = _this select 0;
 
	_cam cameraEffect ["terminate", "back"];
	camDestroy _cam;
	enableRadio true;
	_cam;
};
 
 
/*##################################################################
 
Suivre avec la camra un objet en dplacement ou pas  partir 
d'un autre objet en mouvement ou pas
 
FNCT_CamFollow()
	@param1 Porteur de la camera
	@param2 cible de la camera
	@param3 dure du plan (en seconde)
	@param4 Offset de position de la camera par rapport au vhicule  suivre (x,y,z)
	@param5 la camra
 
	@return la camera
 
Ex : [OFF1,OFF2,10,[0,-1,1.8],_cam] call FNCT_CamFollow;
 
#################################################################*/
 
 
FNCT_CamFollow = {
    _porteur    = _this select 0;
    _cible      = _this select 1;
    _duree      = _this select 2;
    _camOffset  = _this select 3;
    _cam        = _this select 4;
 
    _start = time;
 
    while {((time - _start)< _duree) && (alive _porteur) } do {
 
    	_pos = position _porteur;
    	_x   = _pos select 0;
    	_y   = _pos select 1;
    	_z   = _pos select 2;
 
    	_cam camSetPos [ 
    		_x + (_camOffset select 0 ), 
    		_y + (_camOffset select 1 ), 
    		_z + (_camOffset select 2 )
    	];
 
    	_cam camSetTarget _cible;
 
    	_cam camCommit 0;
    	sleep 0.002;
    };
   _cam;
};